<?php
$pageTitle = "مدیریت کاربران";
$iconUrl = "logo.jpg";
require_once "./components/header.php";
require_once "../../utilities/auth/helper.php";
require_once "../../app/controller/admin/UsersController.php";
require_once "../../layouts/admin/nav.php";
require_once "../../layouts/admin/sidebar.php";
$allUsers = getUsers();
?>
<!-- ------------------------------------------------ Dashboard card section ------------------------------------------------------>
<section class="mx-auto px-28 mt-14 pb-5">
    <div class="max-w-6xl overflow-x-auto mx-auto">
        <div class="flex justify-between items-center mb-3">
            <h2 class="text-xl font-semibold">
                لیست تمامی کاربران
            </h2>
            <a href="./registerUser.php" class="bg-sky-600 hover:bg-sky-700 text-white py-2 p-3 text-sm">
                ایجاد حساب کاربری
            </a>
        </div>
        <table class="min-w-full text-left text-sm font-light">
            <thead class="border border-gray-800">
                <tr class="bg-gray-800">
                    <th scope="col" class="p-3 text-white font-semibold text-center">
                        #
                    </th>
                    <th scope="col" class="p-3 text-white font-semibold text-center">
                        اسم
                    </th>
                    <th scope="col" class="p-3 text-white font-semibold text-center">
                        فامیلی
                    </th>
                    <th scope="col" class="p-3 text-white font-semibold text-center">
                        اسم کاربری
                    </th>
                    <th scope="col" class="p-3 text-white font-semibold text-center">
                        نوعیت حساب
                    </th>
                    <th scope="col" class="p-3 text-white font-semibold text-center">
                        محدودیت درخواست روزانه
                    </th>
                    <th scope="col" class="p-3 text-white font-semibold text-center w-24">
                        عملیات
                    </th>
                </tr>
            </thead>
            <tbody class="border border-dashed border-gray-600" id="results">
                <?php
                $counter = 1;
                if (count($allUsers) > 0) :
                    foreach ($allUsers as $user) : ?>
                        <tr class="even:bg-gray-100">
                            <td class="whitespace-nowrap px-3 py-3 text-center font-bold">
                                <?= $counter ?>
                            </td>
                            <td class="whitespace-nowrap px-3 py-3 text-center font-bold">
                                <?= $user['name'] ?>
                            </td>
                            <td class="whitespace-nowrap px-3 py-3 text-center font-bold">
                                <?= $user['lastName'] ?>
                            </td>
                            <td class="whitespace-nowrap px-3 py-3 text-center font-bold">
                                <?= $user['userName'] ?>
                            </td>
                            <td class="whitespace-nowrap px-3 py-3 text-center font-bold">
                                <?= $user['role'] ?>
                            </td>
                            <td class="whitespace-nowrap px-3 py-3 text-center font-bold">
                                <?= $user['request_limit'] ?>
                            </td>
                            <td class="whitespace-nowrap w-24">
                                <div class="flex justify-center gap-1 items-center px-2">
                                    <a title="ویرایش کاربر" class="cursor-pointer" href="./updateUser.php?updateUser=<?= $user['id'] ?>">
                                        <img src="../../public/icons/edit.svg" alt="edit icon">
                                    </a>
                                    <a title="حذف کاربر " class="cursor-pointer" type="submit" onclick="confirmDeletion(this)" data-id="<?= $user['id'] ?>">
                                        <img src="../../public/icons/delete.svg" alt="delete icon">
                                    </a>
                                </div>
                            </td>
                        </tr>
                    <?php
                        $counter += 1;
                    endforeach;
                else : ?>
                    <tr v-else class="transition duration-300 ease-in-out bg-neutral-200">
                        <td colspan="6" class="whitespace-nowrap px-3 py-3 text-center text-red-500 font-bold">
                            <i class="material-icons text-red-500">mood_bad</i>
                            <br />
                            !متاسفانه چیزی برای نمایش در پایگاه داده
                            موجود نیست
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</section>
<script>
    function confirmDeletion(element) {
        const user_id = element.getAttribute('data-id');
        if (confirm("آیا مطمئن هستید که این حساب کاربری را میخواهید حذف کنید؟")) {
            deleteAccount(user_id);
        }
    }

    function deleteAccount(userId) {
        const params = new URLSearchParams();
        params.append('deleteUser', 'deleteUser');
        params.append('userId', userId);

        axios.post('../../app/api/admin/UsersAPI.php', params)
            .then((response) => {
                if (response.data) {
                    alert('حساب کاربری مورد نظر موفقانه حذف شد.');
                    window.location.reload();
                }
            })
            .catch((e) => {
                console.log(e);
            });

    }
</script>
<?php
require_once "./components/footer.php";
?>