<?php
if (!isset($__DATABASE)) {
    header("Location: " . $__FORBID_ADDR);
}
function isLogin()
{
    if (isset($_SESSION["isLogin"]) && $_SESSION["isLogin"] != true) {
        return false; // retune false if the successful login is not set
    }

    if (isLoginSessionExpired()) {
        return false;
    }

    if (isset($_SESSION["isLogin"])) {
        return true;
    }

    if (isAccessLevelSet()) {
        return false;
    }

    return true;
}

function isLoginSessionExpired()
{
    // Check if the session has expired (current time > expiration time)
    if (isset($_SESSION["expiration_time"]) && time() > $_SESSION["expiration_time"]) {
        return true;
    }
    return false;
}

function authModified($id)
{
    return false;
}

function isAccessLevelSet()
{
    if (!isset($_SESSION["not_allowed"])) {
        return true;
    }
    return false;
}

function isAdmin()
{
    return isset($_SESSION['role']) && $_SESSION['role'] == 'admin';
}

function redirectUser()
{
    if (isAdmin()) {
        header("Location: ../admin/index.php");
        exit;
    }

    header("Location: ../common/prices.php");
    exit;
}

function isAllowedToProceed()
{
    if (!isAdmin()) {
        header("Location: ../common/prices.php");
    }
}
