<?php
// Check if the request is a POST request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: ../../../views/auth/403.php");
    exit;
}

require_once '../../../config/constants.php';
require_once '../../../database/db_connect.php';
require_once '../../../app/middleware/Authentication.php';
require_once '../../../app/middleware/Authorize.php';

if (isset($_POST['getRequestLimit'])) {
    $user_id = trim($_POST['userID']);

    echo getRequestLimit($user_id);
}

function getRequestLimit($user_id)
{
    $stmt = PDO_CONNECTION->prepare("SELECT 
                                        u.request_limit - COALESCE(COUNT(r.id), 0) AS remaining_requests
                                    FROM 
                                        users u
                                    LEFT JOIN 
                                        requests r ON r.user_id = u.id AND DATE(r.created_at) = CURDATE()
                                    WHERE 
                                        u.id = :id
                                    GROUP BY 
                                        u.request_limit;");
    $stmt->bindParam(":id", $user_id);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    return $result['remaining_requests'];
}

if (isset($_POST['updateRequestLimit'])) {
}
